<?php	
    /*
     * Copyright (c) 2015-2023 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * Questa classe consente di creare una sitemap da inviare ai motori di ricerca. È possibile stampare
     * la mappa in un file o farsi restituire come output il codice della mappa.
     * 
     * Il parametro $db serve solo se si vuole utilizzare il metodo creaSitemapDaDatabase
     */

    class GeneratoreSiteMap {
        private $db;
        private $impostazioni;
        private $codiceSitemap;
        
        public function __construct($db,$impostazioni) {
            $this->db            = $db;
            $this->impostazioni  = $impostazioni;
            $this->codiceSitemap = "";
        }
        
        /*
         * Metodo per creare la mappa 
         * Questi devono essere passati come parametro in un array associativo dove ogni elemento deve contenere: 
         *	tabella     -> la tabella con i contenuti che si vuole mappare
         *	frequenza   -> la frequenza di aggiornamento dei contenuti
         *	link        -> il link di base della pagina che mostra i contenuti della tabella
         *   colonnaParametroLink -> la colonna della tabelal che contiene l'identificativo di quell'articolo
         *	colonnaDataCreazione -> la colonna della tabella che contiene e informazioni sulla data dell'ultimo aggiornamento
         */
        public function creaSitemapDaDatabase($tabelle) {
            $this->codiceSitemap = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
            $this->codiceSitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
            
            foreach($tabelle as $singolaTabella) {
                $frequenza = isset($singolaTabella["frequenza"]) ? $singolaTabella["frequenza"] : ""; 
                if(isset($singolaTabella["parametri"])) {
                    $this->codiceSitemap .= $this->creaSezioneSitemapDaDatabase($singolaTabella["tabella"],$frequenza,$singolaTabella["colonnaDataCreazione"],$singolaTabella["parametri"]);
                }
                else {
                    $this->codiceSitemap .= $this->creaSezioneSitemapDaDatabase($singolaTabella["tabella"],$singolaTabella["frequenza"],$singolaTabella["colonnaDataCreazione"]);
                }
            }
            
            $this->codiceSitemap .= '</urlset>';
        }

        /*
         * Questo metodo serve per creare una mappa del sito che contiene altre mappe
         * prende in input un array con le mappe e genera il codice mettendo come ultima modifica la data passata
         * in input o la data odierna
         */
        public function creaIndiceSitemap($arraySitemap, $data="") {
            $this->codiceSitemap = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
            $this->codiceSitemap .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
            
            $ultimaModifica = ($data!="") ? $data : date("Y-m-d");
            foreach($arraySitemap as $sitemap) {
                $this->aggiungiSingoloElemento($sitemap,$ultimaModifica,$tag="sitemap",);
            }
            
            $this->codiceSitemap .= '</urlset>';
        }
        
        public function creaSezioneSitemapDaDatabase($tabella,$frequenza,$colonnaDataUltimaModifica,$parametri = null) {
            $query = "SELECT * FROM $tabella";
            if($parametri != null) {
                $query .= " WHERE ";
                foreach($parametri as $nome=>$valore) {
                    $query .= "$nome = '$valore' AND ";
                }
                $query = substr($query,0,-4);
            }
            
            $risQuery = $this->db->eseguiQueryLettura($query);
            while($elemento = $risQuery->fetch_assoc()) {
                
                $ultimaModifica = date("Y-m-d",strtotime($elemento[$colonnaDataUltimaModifica]));
                $linkElemento   = $this->costruisciIndirizzo($elemento,$ultimaModifica);
                $this->aggiungiSingoloElemento($linkElemento,$ultimaModifica,"url",$frequenza);
            }
        }
        
        public function aggiungiSingoloElemento($linkElemento,$ultimaModifica,$tag="url",$frequenzaAggiornamento = "",$immagine = "") {            
            $codiceSingoloElemento = "<$tag>
                <loc>$linkElemento</loc>
                <lastmod> $ultimaModifica </lastmod>";
            if($frequenzaAggiornamento!="") {
                $codiceSingoloElemento .= "    <changefreq>$frequenzaAggiornamento</changefreq>";
            }
            if($immagine!="") {
                $codiceSingoloElemento .= "    <image:image>"
                        . "<image:loc>$immagine</image:loc>"
                        . "</image:image>";
            }
            $codiceSingoloElemento .= "</$tag>\n";
            
            $this->codiceSitemap .= $codiceSingoloElemento;
        }
        
        public function costruisciIndirizzo($elemento) {
            
        }
        
        public function salvaSuFile($nomeFile) {
            if($nomeFile!="") {            
                $file = fopen($nomeFile, "w");
                fwrite($file, $this->codiceSitemap);
                fclose($file);
            }
        }
        
        // getter & setter
        public function getCodiceSitemap() {
            return $this->codiceSitemap;
        }

        public function getImpostazioni() {
            return $this->impostazioni;
        }

        public function setCodiceSitemap($codiceSitemap): void {
            $this->codiceSitemap = $codiceSitemap;
        }

        public function setImpostazioni($impostazioni): void {
            $this->impostazioni = $impostazioni;
        }
    }